local function ssmTextColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#FF0000");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#FFCF6A");
	else
		return color("#FFFFFF");
	end
end;

local function ssmStrokeColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#111E33");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#000000");
	else
		return color("#5A292C");
	end
end;

local function ssmTitleColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#FF0000");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#FFCF6A");
	else
		return color("#FFFFFF");
	end
end;

local t = LoadFallbackB();
local function NoMoreSaving()
	if getenv(save,nil) then
		setenv(save,0);
	end
end;
local scx = SCREEN_CENTER_X;
local scy = SCREEN_CENTER_Y;
local sb = SCREEN_BOTTOM;
local st = SCREEN_TOP;
local sl = SCREEN_LEFT;
local sr = SCREEN_RIGHT;
local cmode = GAMESTATE:IsCourseMode();
local human_1 = GAMESTATE:IsHumanPlayer(PLAYER_1);
local human_2 = GAMESTATE:IsHumanPlayer(PLAYER_2);

if not cmode then
	NoMoreSaving()
t[#t+1] = LoadActor("_panedisplayp1") .. {
		InitCommand=function(self) self:visible(human_1):xy(sl+135,scy+125) end;
		OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
		OnCommand=function(self) self:diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1) end;
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				self:visible(true):diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1)
			end;
		end;
		PlayerUnjoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				self:diffusealpha(1):decelerate(0.3):diffusealpha(0):visible(false)
			end;
		end;
	};

t[#t+1] = LoadActor("_panedisplayp2") .. {
		InitCommand=function(self) self:visible(human_2):xy(sr-151,scy+125) end;
		OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
		OnCommand=function(self) self:diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1) end;
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				self:visible(true):diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1)
			end;
		end;
		PlayerUnjoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				self:diffusealpha(1):decelerate(0.3):diffusealpha(0):visible(false)
			end;
		end;
	};


t[#t+1] = LoadActor("_p1diffpod") .. {
	InitCommand=function(self) self:visible(human_1):xy(sl+90,scy+60) end;
	OnCommand=function(self) self:diffusealpha(0):sleep(0.5):smooth(0.2):diffusealpha(1) end;
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_1 then
			self:visible(true):diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1)
		end;
	end;
	PlayerUnjoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_1 then
			self:diffusealpha(1):decelerate(0.3):diffusealpha(0):visible(false)
		end;
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};

t[#t+1] = LoadActor("_p2diffpod") .. {
	InitCommand=function(self) self:visible(human_2):xy(sr-90,scy+60) end;
	OnCommand=function(self) self:diffusealpha(0):sleep(0.5):smooth(0.2):diffusealpha(1) end;
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_2 then
			self:visible(true):diffusealpha(0):sleep(0.5):decelerate(0.3):diffusealpha(1)
		end;
	end;
	PlayerUnjoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_2 then
			self:diffusealpha(1):decelerate(0.3):diffusealpha(0):visible(false)
		end;
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};



-- Name That Tune! or... folder?
t[#t+1] = LoadFont("_pixellari 32px") .. { -- Title
		InitCommand=function(self) self:maxwidth(450):horizalign(center):visible(not cmode) end;
		OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):addy(-10) end;
		OnCommand=function(self) self:diffuse(ssmTitleColor()):strokecolor(ssmStrokeColor()) end;
		CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			if song then
				local stitle = GAMESTATE:GetCurrentSong():GetDisplaySubTitle();
				if stitle == "" or stitle == nil then
					self:zoom(0.85):xy(scx,scy)
				else
					self:zoom(0.65):xy(scx,scy-7)
				end
				self:smooth(0.2);
				self:diffusealpha(0);
				self:addx(10);
				self:settext(song:GetDisplayMainTitle());
				self:playcommand("Refresh");
				self:stoptweening():addy(-6):diffusealpha(0):smooth(0.2):addy(6):diffusealpha(1);
			else
				self:settext("");
				self:playcommand("Refresh");
            end
        end;
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Subtitle
          InitCommand=function(self) self:zoom(0.4):xy(scx,scy+10):maxwidth(600):horizalign(center):visible(not cmode) end;
		  OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):zoom(0.2) end;
		  OnCommand=function(self)
				self:diffuse(ssmTitleColor()):strokecolor(ssmStrokeColor());
		  end;
          CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetDisplaySubTitle());
                    self:playcommand("Refresh");
					self:stoptweening():zoom(0.3):diffusealpha(0):smooth(0.2):zoom(0.4):diffusealpha(1);
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Artist
          InitCommand=function(self) self:xy(scx,scy+25):maxwidth(450):horizalign(center):zoom(0.6):visible(not cmode) end;
		  OnCommand=function(self) self:diffuse(ssmTextColor()):strokecolor(ssmStrokeColor()) end;
		  OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):addy(10) end;
          CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(-10);
                    self:settext(song:GetDisplayArtist());
                    self:playcommand("Refresh");
					self:stoptweening():addy(6):diffusealpha(0):smooth(0.2):addy(-6):diffusealpha(1);
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};

t[#t+1] = LoadFont("Common normal") .. { -- Genre (top)
          InitCommand=function(self) self:xy(scx,scy-150):maxwidth(500):horizalign(center):zoom(0.6):visible(not cmode) end;
		  OnCommand=function(self) self:diffuse(ssmTextColor()):strokecolor(ssmStrokeColor()) end;
		  OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):addy(10) end;
          CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
			   local group = SCREENMAN:GetTopScreen():GetMusicWheel():GetSelectedSection();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
                    self:settext(song:GetGenre());
                    self:playcommand("Refresh");
					self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1);
				else
					self:settext("");
					self:playcommand("Refresh");
				end
          end;
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Group name
		InitCommand=function(self) self:maxwidth(450):horizalign(center):visible(not cmode) end;
		OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):addy(-10) end;
		CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			local group = SCREENMAN:GetTopScreen():GetMusicWheel():GetSelectedSection();
			if not song then
				self:zoom(0.85):xy(scx,scy+7);
				self:settext(group):diffusecolor(0.7,0.7,1,0);
				if group == "ULTRA GATE" then
					self:diffusecolor(0.7,0.3,1,0):vibrate():effectmagnitude(3,3,3);
				else
					self:diffusecolor(0.7,0.7,1,0):stopeffect();
				end
				self:playcommand("Refresh");
				self:stoptweening():addy(-6):diffusealpha(0):smooth(0.2):addy(6):diffusealpha(1);
			else
				self:settext("");
				self:playcommand("Refresh");
            end
        end;
	};
-- extra decoration
t[#t+1] = LoadActor("_bpm") .. {
	InitCommand=function(self) self:x(scx-140):y(55):zoom(0.5) end;
	OnCommand=function(self) self:diffusealpha(0):linear(0.4):diffusealpha(1) end;
	OffCommand=function(self) self:linear(0.4):diffusealpha(0) end;
};
t[#t+1] = LoadActor("_length") .. {
	InitCommand=function(self) self:x(scx+140):y(55):zoom(0.5) end;
	OnCommand=function(self) self:diffusealpha(0):linear(0.4):diffusealpha(1) end;
	OffCommand=function(self) self:linear(0.4):diffusealpha(0) end;
};

t[#t+1] = LoadActor("_longsong") .. {
	InitCommand=function(self) self:x(scx+140):y(st+91):zoom(0.6) end;
	OffCommand=function(self) self:linear(0.4):diffusealpha(0) end;
	CurrentSongChangedMessageCommand=function(self) self:playcommand("Set") end;
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if not song then
			self:finishtweening():diffusealpha(0)
		elseif song:IsLong() then
			self:playcommand("Blink")
		else
			self:finishtweening():diffusealpha(0)
		end
	end;
	BlinkCommand=function(self) self:diffusealpha(1):sleep(0.4):diffusealpha(0):sleep(0.4):queuecommand("Blink") end;
};
t[#t+1] = LoadActor("_marathonsong") .. {
	InitCommand=function(self) self:x(scx+140):y(st+91):zoom(0.6) end;
	OffCommand=function(self) self:linear(0.4):diffusealpha(0) end;
	CurrentSongChangedMessageCommand=function(self) self:playcommand("Set") end;
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if not song then
			self:finishtweening():diffusealpha(0)
		elseif song:IsMarathon() then
			self:playcommand("Blink")
		else
			self:finishtweening():diffusealpha(0)
		end
	end;
	BlinkCommand=function(self) self:diffusealpha(1):sleep(0.25):diffusealpha(0):sleep(0.25):queuecommand("Blink") end;
};
-- Player names
local machine = PROFILEMAN:GetMachineProfile();
local name1 = PROFILEMAN:GetPlayerName(PLAYER_1);
local name2 = PROFILEMAN:GetPlayerName(PLAYER_2);
t[#t+1] = LoadFont("Common normal") .. {
          InitCommand=function(self) self:xy(scx-250,scy+30):maxwidth(390):horizalign(center):zoom(0.9):visible(not cmode and human_1 or GAMESTATE:IsSideJoined(PLAYER_1)) end;
		  OnCommand=function(self)
			if name1 == "" or name1 == machine then
				self:settext("PLAYER 1")
			else
				self:settext(name1)
			end
			self:diffuse(ColorLightTone(PlayerColor(PLAYER_1))):diffusealpha(0):sleep(0.2):linear(0.3):diffusealpha(1):maxwidth(225);
		  end;
		  OffCommand=function(self) self:smooth(0.3):diffusealpha(0) end;
};
t[#t+1] = LoadFont("Common normal") .. {
          InitCommand=function(self) self:xy(scx+250,scy+30):maxwidth(390):horizalign(center):zoom(0.9):visible(not cmode and human_2 or GAMESTATE:IsSideJoined(PLAYER_2)) end;
		  OnCommand=function(self)
			if name2 == "" or name2 == machine then
				self:settext("PLAYER 2")
			else
				self:settext(name2)
			end
			self:diffuse(ColorLightTone(PlayerColor(PLAYER_2))):diffusealpha(0):sleep(0.2):linear(0.3):diffusealpha(1):maxwidth(225);
		  end;
		  OffCommand=function(self) self:smooth(0.3):diffusealpha(0) end;
		};
		
end



if cmode then
	
-- Course name	
t[#t+1] = Def.ActorFrame {
	OnCommand=function(self) self:diffusealpha(0):sleep(3.2):smooth(0.4):diffusealpha(1) end;
	LoadFont("_coaster") .. { -- course title text
          InitCommand=function(self) self:xy(scx,scy-145):maxwidth(450):zoom(0.75) end;
		  OffCommand=function(self) self:decelerate(0.3):diffusealpha(0) end;
		  OnCommand=function(self) self:diffusealpha(0):queuecommand("Set"):sleep(0.4):decelerate(0.4):diffusealpha(1) end;
		  CurrentSongChangedMessageCommand=function(self) self:queuecommand("Set") end;
          CurrentCourseChangedMessageCommand=function(self) self:queuecommand("Set") end;
          ChangedLanguageDisplayMessageCommand=function(self) self:queuecommand("Set") end;
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse(); 
               if course then
					self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(course:GetDisplayFullTitle()); 
                    self:queuecommand("Refresh");
					self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1)
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end 
          end; 
	};

	LoadFont("_dot matrix 32px") .. { -- course type text
          InitCommand=function(self) self:xy(scx,scy-165):maxwidth(450):zoom(0.55) end;
		  OffCommand=function(self) self:decelerate(0.3):diffusealpha(0) end;
		  OnCommand=function(self) self:diffusealpha(0):queuecommand("Set"):sleep(0.4):decelerate(0.4):diffusealpha(1) end;
		  CurrentSongChangedMessageCommand=function(self) self:queuecommand("Set") end;
          CurrentCourseChangedMessageCommand=function(self) self:queuecommand("Set") end;
          ChangedLanguageDisplayMessageCommand=function(self) self:queuecommand("Set") end;
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse();
               if course then
					self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(CourseTypeToLocalizedString(course:GetCourseType())); 
                    self:queuecommand("Refresh");
					self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1)
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end 
          end; 
	};
};

t[#t+1] = StandardDecorationFromFileOptional("CourseContentsList","CourseContentsList");

t[#t+1] = Def.ActorFrame {
	OnCommand=function(self) self:diffusealpha(0):sleep(3.2):smooth(0.4):diffusealpha(1) end;
	LoadFont("_g7 star force ttf 20px") .. { -- stagecount
		InitCommand=function(self) self:xy(scx-255,scy-37):diffuse(color("#FFFFFF")):strokecolor(color("#000000")) end;
		CurrentCourseChangedMessageCommand=function(self) self:queuecommand("Set") end;
		ChangedLanguageDisplayMessageCommand=function(self) self:queuecommand("Set") end;
		OnCommand=function(self) self:zoomy(0):decelerate(0):zoomy(1) end;
		OffCommand=function(self) self:decelerate(0.3):zoomy(0) end;
		SetCommand=function(self) 
			local course = GAMESTATE:GetCurrentCourse(); 
				if course then
					self:settext(course:GetEstimatedNumStages()); 
					self:queuecommand("Refresh");
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
				end
		end;
	};
		
		
	LoadFont("_dot matrix 32px") .. { --stagecount text
        InitCommand=function(self) self:zoom(0.5):xy(scx-255,scy-57):diffuse(color("#FFFFFF")):settext("# OF SONGS") end;
		OnCommand=function(self) self:diffuse(color("#FFFFFF")):strokecolor(color("#000000")) end;
		OffCommand=function(self) self:accelerate(0.2):diffusealpha(0) end;
	};
		 
	LoadFont("_dot matrix 32px") .. { --length text
        InitCommand=function(self) self:zoom(0.5):xy(scx+255,scy-57):diffuse(color("#FFFFFF")):settext("LENGTH") end;
		OnCommand=function(self) self:diffuse(color("#FFFFFF")):strokecolor(color("#000000")):diffusealpha(0):smooth(1):diffusealpha(1) end;
		OffCommand=function(self) self:accelerate(0.2):diffusealpha(0) end;
	};
};
end;

t[#t+1] = LoadActor("_ssm footer") .. {
			InitCommand=function(self) self:xy(scx,sb+50) end;
			OnCommand=function(self)
				if cmode then
					self:zoom(0.6):sleep(3.2):smooth(0.5):addy(-65)
				else
					self:zoom(0.6):sleep(0.5):smooth(0.5):addy(-65)
				end;
			end;
			OffCommand=function(self) self:sleep(0.4):smooth(0.4):addy(65) end;
	};

t[#t+1] = LoadFont("_arcade normal 20px") .. {
        InitCommand=function(self) self:zoom(0.5):xy(scx,sb-22):uppercase(true):diffuse(color("#FFFFFF")) end;
		OnCommand=function(self)
			if cmode then
				self:diffusealpha(0):sleep(3.4):smooth(0.3):diffusealpha(1)
			else
				self:diffusealpha(0):sleep(0.7):smooth(0.3):diffusealpha(1)
			end
		end;
		OffCommand=function(self) self:decelerate(0.3):diffusealpha(0) end;
        SortOrderChangedMessageCommand=function(self) self:playcommand("Set") end;
        ChangedLanguageDisplayMessageCommand=function(self) self:playcommand("Set") end;
        SetCommand=function(self)
				local sortorder = GAMESTATE:GetSortOrder();
				if sortorder then
					self:finishtweening();
					self:smooth(0.4);
					self:diffusealpha(0);
					self:addx(6);
					if sortorder == "SortOrder_ModeMenu" then
						if not cmode then
							self:settext("Sort Menu");
						else
							self:settext("Course Type");
						end
					else
						self:settext(SortOrderToLocalizedString(sortorder));
					end
					self:playcommand("Refresh");
					self:stoptweening():diffusealpha(0):smooth(0.35):diffusealpha(1)
				else
					self:settext("");
					self:playcommand("Refresh");
				end
		end;
};


t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. { -- length
	InitCommand=function(self) self:zoom(0.8):addx(37) end;
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if cmode then
			curSelection = GAMESTATE:GetCurrentCourse();
			self:playcommand("Reset");
			if curSelection then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
				if trail then
					length = TrailUtil.GetTotalSeconds(trail);
				else
					length = 0.0;
				end;
			else
				length = 0.0;
			end;
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
		end;
		self:settext( SecondsToMSS(length) );
	end;
	CurrentSongChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentCourseChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentTrailP1ChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentTrailP2ChangedMessageCommand=function(self) self:playcommand("Set") end;
};

if not cmode then
	t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
end;


t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=function(self) self:draworder(160):FullScreen():diffuse(color("0,0,0,1")):diffusealpha(0) end;
		ShowPressStartForOptionsCommand=function(self) self:sleep(0.2):decelerate(0.5):diffusealpha(1) end;
	};
};

t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
	ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t
